<?php

function getUsers($sock)
{
   $users = ParamGet($sock, "security");
   $users = $users->security->user;
   return $users;
}

function getPrefix($sock)
{
   $users = getUsers($sock);
   $userIndex = $users[0]->index;
   return "security.user.[" . $userIndex . "].";
}

function InputFileCheck()
{
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }
}
function checkDecodeJson($object)
{
   if (!is_array($object) || isContainNull($object)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
}
function addLikeTemplateUser($sock, $object, $newuserlogin, $newuserpass)
{
   $security = ParamGet($sock, "security");
   $donor = GetUserById($object["newusertemplate"], $security);
   $newuserlevel = $donor->accesslevel;
   UserAdd($sock, $newuserlogin, $newuserpass, $newuserlevel);
   $prefix = getPrefix($sock);
   if (isset($donor->txlimit)) {
      $newuserlimit = $donor->txlimit;
      ParamSetInt($sock, $prefix . "txlimit", $newuserlimit);
   }
   if (isset($donor->deny)) {
      if (isset($donor->deny->net->adapters)) {
         $newuseradapter = $donor->deny->net->adapters;
         ParamSetInt($sock, $prefix . "deny.net.adapters", $newuseradapter);
      }
      if (isset($donor->deny->misc)) {
         $newusermMisc = $donor->deny->misc;
         foreach ($newusermMisc as $key => $value) {
            ParamSetInt($sock, $prefix . "deny.misc." . $key, $value);
         }
      }
      if (isset($donor->deny->camera)) {
         $newusercameras = $donor->deny->camera;
         $index = 0;
         foreach ($newusercameras as $camera) {
            foreach ($camera as $key => $value) {
               ParamSetInt($sock, $prefix . "deny.camera.[" . $index . "]." . $key, $value);
            }
            $index++;
         }
      }
      if (isset($donor->deny->sound)) {
         $newusersounds = $donor->deny->sound;
         $index = 0;
         foreach ($newusersounds as $sound) {
            foreach ($sound as $key => $value) {
               ParamSetInt($sock, $prefix . "deny.sound.[" . $index . "]." . $key, $value);
            }
            $index++;
         }
      }
   }
}
function addLikeNew($sock, $object, $newuserlogin, $newuserpass)
{
   $newuserlevel = $object["newuserlevel"];
   $newuserlimit = round(($object["newuserlimit"] * 1000000) / 8);
   $newuseradapter = $object["newuseradapter"];
   UserAdd($sock, $newuserlogin, $newuserpass, $newuserlevel * 10);

   $prefix = getPrefix($sock);

   if ($newuserlimit >= 0) {
      ParamSetInt($sock, $prefix . "txlimit", $newuserlimit);
   }

   if ($newuseradapter != null) {
      $eth_deny = $newuseradapter;
      if ($eth_deny >= 0 && $eth_deny <= 2) {
         ParamSetInt($sock, $prefix . "deny.net.adapters", $eth_deny);
      }
   }
}
